/* eslint-disable max-len */
// normally the model is passed to the view instead of the view creating the model
define([
    'underscore',
    'backbone',
    'marionette',
    'modules/form/section-view',
    'text!modules/community-care-request/new-appointment-request-question/notification-selection/request-details/request-details-phone-contact.html',
    'json!modules/community-care-request/new-appointment-request-question/notification-selection/request-details/request-phone-details.json',
], function (
    _,
    Backbone,
    Marionette,
    SectionView,
    CommWithClerkSection,
    metadata
) {
    'use strict';

    return SectionView.extend({
        events: {'keyup input': 'validatePhoneAtMaxLength'},
        template: CommWithClerkSection,
        initialize: function (options) {
            var sectionName = 'request-details-phone-contact-section';
            // when we have values on model, we need to select them
            var bestTimeToCall = this.model.get('bestTimeToCall');

            var newValues = [];
            var defaultValues = [];

            this.legend = this.getLegendFromMetadata(sectionName, metadata, false) || '';
            this.collection = this.getQuestionsFromMetadata(sectionName, metadata);

            /**
                Iterates through best times to call: morning, afternoon, evening.
                It then checks them if already entered and adds them to the model
             */
            _.each(this.collection.get('bestTimeToCall').get('values'), function (valueObj) {
                var key;
                var time;

                // reset selected
                valueObj.selected = false;

                // undefined if first loading this section
                // array of checked times to call
                if (bestTimeToCall) {

                    for (key in bestTimeToCall) {
                        if (bestTimeToCall.hasOwnProperty(key)) {
                            time = bestTimeToCall[key];

                            if (time === valueObj.value) {
                                valueObj.selected = true;
                            }
                        }
                    }
                } else if (valueObj.defaultSelected) {
                    valueObj.selected = true;
                    defaultValues.push(valueObj.value);
                }

                newValues.push(valueObj);
            });

            this.collection.get('bestTimeToCall').set('values', newValues);

            // this updates the wizard model with the correct array of options if any defaults were specified
            if (defaultValues.length > 1) {
                this.model.set('bestTimeToCall', defaultValues);
            }

            // initialize listener to 'change:value' after static values are set
            this.initializeQuestionEventListeners();
        },
        onRender: function () {
            this.initChildren();

        },

        onDomRefresh: function() {
            this.addFormValidationRules();
        },

        addFormValidationRules: function () {
            this.$el.find('#phoneNumber').rules('add', {
                phoneUS: true,
                messages: {phoneUS: 'Please enter a valid US Phone number.'},
            });
        },
        validatePhoneAtMaxLength: function (e) {
            var maxLength = 14;
            if ($(e.currentTarget).val().length === maxLength) {
                $(e.currentTarget).valid();
            }
        },
        updateFDNS   el: function (model) {
            var id = model.get('id');
            var val = model.get('value');
            var selected;
            var timesToCall;

            if (id === 'bestTimeToCall') {
                // get the times to call that are selected
                selected = model.get('selected');

                if (!Array.isArray(selected)) {
                    // sets timesToCall to be an array of all checked times
                    timesToCall = selected ?
                        _.union(this.model.get('bestTimeToCall'), [val]) :
                        _.without(this.model.get('bestTimeToCall'), val);

                    // set bestTimeToCall to have its value be the array of times to call.
                    this.model.set(id, timesToCall);
                }
            } else {
                this.model.set(id, val);
            }
        },
    });
});
